/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#include <linux/wait.h>


#define BMCL_VERSION_MAJOR 1
#define BMCL_VERSION_MINOR 0
#define BMCL_VERSION_REVISION 0

#define BMCL_DEV_MAJOR 158
#define BMCL_DEV_MINOR_NUM 1

#define BMCL_IOC_MAGIC   'B'

typedef struct _bmcl_void_arg_t {
    INT32 error;
} bmcl_void_arg_t;

typedef struct _bmcl_alloc_buf_arg_t {
    INT32 error;
    UINT32 size;
    UINT8 mode;
    UINT8 ch;
    UINT32 buf_id;
} bmcl_alloc_buf_arg_t;

typedef struct _bmcl_bufid_arg_t {
    INT32 error;
    UINT32 buf_id;
} bmcl_bufid_arg_t;

typedef struct _bmcl_connect_buf_arg_t {
    INT32 error;
    UINT32 num;
    UINT32 buf_id;
    UINT32 buf_list[0];
} bmcl_connect_buf_arg_t;

typedef struct _bmcl_assign_id_buf_arg_t {
    INT32 error;
    BMCL_bufid_info_t bufid_info;
    UINT8 mode;
    UINT32 buf_id;
} bmcl_assign_id_buf_arg_t;

typedef struct _bmcl_bufmode_arg_t {
    INT32 error;
    UINT32 buf_id;
    UINT8 mode;
} bmcl_bufmode_arg_t;

typedef struct _bmcl_bufnum_arg_t {
    INT32 error;
    UINT32 buf_id;
    UINT32 num;
} bmcl_bufnum_arg_t;

typedef struct _bmcl_bufch_arg_t {
    INT32 error;
    UINT32 buf_id;
    UINT8 ch;
} bmcl_bufch_arg_t;

typedef struct _bmcl_free_bufinfo_arg_t {
    INT32 error;
    UINT32 num;
    UINT32 mode;
    UINT8 ch;
    UINT32 free_blk_num;
    UINT32 size[0];
} bmcl_free_bufinfo_arg_t;

typedef struct _bmcl_bufinfo_arg_t {
    INT32 error;
    UINT32 buf_id;
    BMCL_bufid_info_t bufid_info;
} bmcl_bufinfo_arg_t;

typedef struct _bmcl_con_bufinfo_arg_t {
    INT32 error;
    UINT32 buf_id;
    UINT32 index;
    UINT32 num;
    BMCL_connect_buf_t connect_info[0];
} bmcl_con_bufinfo_arg_t;

typedef struct _bmcl_write_buf_arg_t {
    INT32 error;
    UINT32 buf_id;
    UINT32 size;
    UINT32 offset;
    UINT32 buffer;
} bmcl_write_buf_arg_t;

typedef struct _bmcl_read_buf_arg_t {
    INT32 error;
    UINT32 buf_id;
    UINT32 size;
    UINT32 offset;
    UINT32 buffer;
} bmcl_read_buf_arg_t;

typedef struct _bmcl_copy_buf_arg_t {
    INT32 error;
    UINT32 src_buf_id;
    UINT32 src_offset;
    UINT32 dst_buf_id;
    UINT32 dst_offset;
    UINT32 size;
} bmcl_copy_buf_arg_t;

typedef struct _bmcl_purge_cache_arg_t {
    INT32 error;
    UINT32 buf_id;
    UINT32 offset;
    UINT32 size;
    UINT8 mode;
} bmcl_purge_cache_arg_t;

typedef struct _bmcl_dump_buf_arg_t {
    INT32 error;
    UINT32 buf_id;
    UINT32 offset;
    UINT32 size;
} bmcl_dump_buf_arg_t;


typedef union _bmcl_arg_t{
    INT32 error;
    bmcl_void_arg_t void_arg;
    bmcl_alloc_buf_arg_t alloc_buf;
    bmcl_bufid_arg_t bufid;
    bmcl_connect_buf_arg_t conbuf;
    bmcl_assign_id_buf_arg_t assignid;
    bmcl_bufmode_arg_t bufmode;
    bmcl_bufnum_arg_t bufnum;
    bmcl_bufch_arg_t bufch;
    bmcl_free_bufinfo_arg_t free_bufinfo;
    bmcl_bufinfo_arg_t bufinfo;
    bmcl_con_bufinfo_arg_t con_bufinfo;
    bmcl_write_buf_arg_t write_buf;
    bmcl_read_buf_arg_t read_buf;
    bmcl_copy_buf_arg_t copy_buf;
    bmcl_purge_cache_arg_t purge;
    bmcl_dump_buf_arg_t dump_buf;
}bmcl_arg_t;

#define BMCL_IOC_ASSIGN_ID_BUF            _IOR(BMCL_IOC_MAGIC,3, bmcl_assign_id_buf_arg_t)
#define BMCL_IOC_RELEASE_ID_BUF           _IOR(BMCL_IOC_MAGIC,4, bmcl_bufid_arg_t)
#define BMCL_IOC_GET_BUFINFO              _IOR(BMCL_IOC_MAGIC,9, bmcl_bufinfo_arg_t)

